<?php
class SubscriptionsAdmin
{
  private $dbo = null;
  
  function __construct($dbo)
  {
    $this->dbo = $dbo;
  }
  
  function showList()
  {
    if(!$this->dbo){
      echo 'Lista subskrypcji nie jest dostpna.';
      return;
    }
    
    //Formowanie zapytania pobierajcego list subskrypcji
    $query = "SELECT COUNT(su.UserId), s.Id, s.Nazwa "
           . "FROM Subskrypcje s LEFT JOIN Subskrypcje_Uzytkownicy su "
           . "ON su.SubskrypcjaId = s.Id "
           . "GROUP BY s.Id";
    
    //Wykonanie zapytania
    if(!$subs = $this->dbo->query($query)){
      return SERVER_ERROR;
    }
    
    //Doczenie szablonu
    include 'templates/subscriptionsList.php';
    return ACTION_OK;
  }

  function getEmailsList()
  {
    if(!$this->dbo){
      return SERVER_ERROR;
    }
    
    //Ustalenie separatora
    if(isset($_GET['separator'])){
      $separator = $_GET['separator'];
      $separator = str_replace(
          array('\n', '\r', '\t'),
          array("\n", "\r", "\t"),
          $separator
          );
    }
    else{
      $separator = ",\n";
    }
    
    //Pobranie wszystkich identyfikatorw z tabeli Subskrypcje
    $query = "SELECT Id FROM Subskrypcje";
    
    if(!$result = $this->dbo->query($query)){
      return SERVER_ERROR;
    }
    
    //Utworzenie cigu identyfikatorw subskrypcji zaznaczonych w formularzu
    $str = '0';
    while($row = $result->fetch_row()){
      if(isset($_GET[$row[0]])){
        $str .= ','.$row[0];
      }
    }
    
    //Formowanie zapytania pobierajcego adresy e-mail
    $query = 'SELECT DISTINCT email FROM Users u '
           . 'INNER JOIN Subskrypcje_Uzytkownicy su '
           . 'ON u.Id = su.userId '
           . 'WHERE su.SubskrypcjaId IN ('.$str.') ';
    
    if(!$result = $this->dbo->query($query)){
      return SERVER_ERROR;
    }
    
    //Ustawienie licznika wierszy
    $rowsNo = $result->num_rows;
    $count = 0;
    
    //Wysanie wynikw do przegldarki
    header("Content-Type: text/plain");
    header("Content-Disposition: attachment; filename=subskrypcje.txt");
    
    while($row = $result->fetch_row()){
      echo $row[0];
      if(++$count < $rowsNo){
        echo $separator;
      }
    }
    return ACTION_OK;
  }
  
}
?>